// liman324@yandex.ru rcl-radio.ru
// 05.01.2026 Omsk
#ifndef AX2358_H
#define AX2358_H

#define AX2358_address 0B1001010

#define INPUT_SUB      0B11000000
// mute поканально и общее
#define FL_SUB         0B11110000
#define FR_SUB         0B11110010
#define CT_SUB         0B11110100
#define SUB_SUB        0B11110110
#define SL_SUB         0B11111000
#define SR_SUB         0B11111010
#define MUTE_SET       0B11111110
// младший бит 1 - это MUTE

// селектор входов, 4 стерео и 6-и канальный вход
#define INPUT_4        0B1000
#define INPUT_3        0B1001
#define INPUT_2        0B1010
#define INPUT_1        0B1011
#define INPUT_6CH      0B1111

// общая громкость и показанальная громкость
#define VOL_MASTER_1   0B11100000
#define VOL_MASTER_10  0B11010000

#define VOL_1CH_1      0B10010000
#define VOL_1CH_10     0B10000000

#define VOL_2CH_1      0B01010000
#define VOL_2CH_10     0B01000000

#define VOL_3CH_1      0B00010000
#define VOL_3CH_10     0B00000000

#define VOL_4CH_1      0B00110000
#define VOL_4CH_10     0B00100000

#define VOL_5CH_1      0B01110000
#define VOL_5CH_10     0B01100000

#define VOL_6CH_1      0B10110000
#define VOL_6CH_10     0B10100000

#define VOL_CLEAR      0B11000100

// расшириное стерео и имешивание стерео в CT и SUB с ослаблением
#define STEREO         0B11000000
#define ATT            0B11000010

#include <Arduino.h>
class AX2358
{
  public:
    AX2358();
        void vol_clear();  
        void setInput(int input);
        void setFunc_stereo(bool stereo);
        void setFunc_att(bool att);
        
        void setVol_master(int vol_master); //  int 0...79 
	void setVol_1(int vol_1); //  int 0...79       
	void setVol_2(int vol_2); //  int 0...79 
        void setVol_3(int vol_3); //  int 0...79 
        void setVol_4(int vol_4); //  int 0...79 
        void setVol_5(int vol_5); //  int 0...79 
        void setVol_6(int vol_6); //  int 0...79 
        
        void setMute(bool mute);// mute 0 - off / 1 - on
        void setMute_fl(bool mute);
        void setMute_fr(bool mute);
        void setMute_sub(bool mute);
        void setMute_sl(bool mute);
        void setMute_sr(bool mute);      
	
  private:
	void writeWire(char a, char b);
};
	
#endif //AX2358_H
                         
