#include <Arduino.h>
#include <Wire.h>
#include "AX2358.h"

AX2358::AX2358(){
	Wire.begin();
}

void AX2358::vol_clear(){
  Wire.beginTransmission(AX2358_address);
  Wire.write (VOL_CLEAR);
  Wire.endTransmission();
}

void AX2358::setMute(bool mute){
  Wire.beginTransmission(AX2358_address);
  Wire.write (MUTE_SET + mute);
  Wire.endTransmission();
}

void AX2358::setMute_fl(bool mute){
  Wire.beginTransmission(AX2358_address);
  Wire.write (FL_SUB + mute);
  Wire.endTransmission();
}
void AX2358::setMute_fr(bool mute){
  Wire.beginTransmission(AX2358_address);
  Wire.write (FR_SUB + mute);
  Wire.endTransmission();
}
void AX2358::setMute_sub(bool mute){
  Wire.beginTransmission(AX2358_address);
  Wire.write (CT_SUB + mute);
  Wire.endTransmission();
}
void AX2358::setMute_sl(bool mute){
  Wire.beginTransmission(AX2358_address);
  Wire.write (SL_SUB + mute);
  Wire.endTransmission();
}
void AX2358::setMute_sr(bool mute){
  Wire.beginTransmission(AX2358_address);
  Wire.write (SR_SUB + mute);
  Wire.endTransmission();
}


void AX2358::setInput(int input){
  Wire.beginTransmission(AX2358_address);
  int in_ch;
  switch(input){
    case 1: in_ch = INPUT_1;break;
    case 2: in_ch = INPUT_2;break;
    case 3: in_ch = INPUT_3;break;
    case 4: in_ch = INPUT_4;break;
    case 5: in_ch = INPUT_6CH;break;
  }
  Wire.write (INPUT_SUB + in_ch);
  Wire.endTransmission();
}

void AX2358::setFunc_stereo(bool stereo){
  Wire.beginTransmission(AX2358_address);
  Wire.write (STEREO + stereo);
  Wire.endTransmission();
}

void AX2358::setFunc_att(bool att){
  Wire.beginTransmission(AX2358_address);
  Wire.write (ATT + att);
  Wire.endTransmission();
}

void AX2358::setVol_master(int vol_master){
  vol_master = 79 - vol_master;
  int vm_10 = vol_master/10;
  int vm_1 = vol_master%10;
  writeWire(VOL_MASTER_1+vm_1, VOL_MASTER_10+vm_10);
}

void AX2358::setVol_1(int vol_1){
  vol_1 = 79 - vol_1;
  int v1_10 = vol_1/10;
  int v1_1 = vol_1%10;
  writeWire(VOL_1CH_1+v1_1, VOL_1CH_10+v1_10);
}
void AX2358::setVol_2(int vol_2){
  vol_2 = 79 - vol_2;
  int v2_10 = vol_2/10;
  int v2_1 = vol_2%10;
  writeWire(VOL_2CH_1+v2_1, VOL_2CH_10+v2_10);
}
void AX2358::setVol_3(int vol_3){
  vol_3 = 79 - vol_3;
  int v3_10 = vol_3/10;
  int v3_1 = vol_3%10;
  writeWire(VOL_3CH_1+v3_1, VOL_3CH_10+v3_10);
}
void AX2358::setVol_4(int vol_4){
  vol_4 = 79 - vol_4;
  int v4_10 = vol_4/10;
  int v4_1 = vol_4%10;
  writeWire(VOL_4CH_1+v4_1, VOL_4CH_10+v4_10);
}
void AX2358::setVol_5(int vol_5){
  vol_5 = 79 - vol_5;
  int v5_10 = vol_5/10;
  int v5_1 = vol_5%10;
  writeWire(VOL_5CH_1+v5_1, VOL_5CH_10+v5_10);
}
void AX2358::setVol_6(int vol_6){
  vol_6 = 79 - vol_6;
  int v6_10 = vol_6/10;
  int v6_1 = vol_6%10;
  writeWire(VOL_6CH_1+v6_1, VOL_6CH_10+v6_10);
}


void AX2358::writeWire(char a, char b){
  Wire.beginTransmission(AX2358_address);
  Wire.write (a);
  Wire.write (b);
  Wire.endTransmission();
}
